<?php
/**
 * Plugin Name: WooCommerce Bengali Product Description
 * Plugin URI: https://sajibdigital.com/
 * Description: Adds a secondary Bengali Product Description tab after the default Description tab in WooCommerce (compatible with Woodmart theme).
 * Version: 1.0
 * Author: Sajib Hossain
 * Author URI: https://sajibdigital.com/
 * License: GPL2
 * Text Domain: woo-bangla-description
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// =====================================================
// Add Bengali Product Description Editor in Backend
// =====================================================


if (!defined('ABSPATH')) exit;

// Add Bengali Description field
add_action('add_meta_boxes', function () {
    add_meta_box(
        'pm_bangla_product_description',
        __('Product Description (Bengali)', 'woo-bangla-description'),
        function ($post) {
            $content = get_post_meta($post->ID, '_pm_bangla_product_description', true);
            wp_editor(
                $content,
                'pm_bangla_product_description_editor',
                [
                    'textarea_name' => '_pm_bangla_product_description',
                    'media_buttons' => true,
                    'textarea_rows' => 10,
                ]
            );
        },
        'product',
        'normal',
        'default'
    );
});

// Save Bengali description
add_action('save_post_product', function ($post_id) {
    if (isset($_POST['_pm_bangla_product_description'])) {
        update_post_meta(
            $post_id,
            '_pm_bangla_product_description',
            wp_kses_post($_POST['_pm_bangla_product_description'])
        );
    }
});

// Inject English + Bengali sub-tabs inside Description
add_filter('woocommerce_product_tabs', function ($tabs) {
    global $post;
    $bangla_content = get_post_meta($post->ID, '_pm_bangla_product_description', true);

    if (!empty($bangla_content) && isset($tabs['description'])) {
        $original_callback = $tabs['description']['callback'];

        $tabs['description']['callback'] = function($key, $tab) use ($original_callback, $bangla_content) {
            ob_start();
            call_user_func($original_callback, $key, $tab);
            $english_content = ob_get_clean();
            ?>
            <div class="sub-description-tabs">
                <ul class="sub-tabs-nav">
                    <li class="active" data-tab="english">English</li>
                    <li data-tab="bengali">বাংলা</li>
                </ul>
                <div class="sub-tabs-content">
                    <div class="sub-tab-panel active" id="tab-english">
                        <?php echo $english_content; ?>
                    </div>
                    <div class="sub-tab-panel" id="tab-bengali">
                        <div class="bangla-description-content" style="font-family:'Noto Sans Bengali',sans-serif;font-size:16px;line-height:1.8;color:#333;">
                            <?php echo wpautop($bangla_content); ?>
                        </div>
                    </div>
                </div>
            </div>
            <style>
            .sub-description-tabs { margin-top:20px; }
            .sub-tabs-nav { display:flex; list-style:none; padding:0; margin-bottom:10px; }
            .sub-tabs-nav li { cursor:pointer; padding:8px 20px; background:#eee; margin-right:5px; border-radius:4px; }
            .sub-tabs-nav li.active { background:#333; color:#fff; }
            .sub-tab-panel { display:none; }
            .sub-tab-panel.active { display:block; }
            </style>
            <script>
            document.addEventListener('DOMContentLoaded', function(){
                const tabs = document.querySelectorAll('.sub-description-tabs .sub-tabs-nav li');
                const panels = document.querySelectorAll('.sub-description-tabs .sub-tab-panel');
                tabs.forEach(tab => {
                    tab.addEventListener('click', function(){
                        tabs.forEach(t => t.classList.remove('active'));
                        panels.forEach(p => p.classList.remove('active'));
                        this.classList.add('active');
                        const target = this.getAttribute('data-tab');
                        document.getElementById('tab-' + target).classList.add('active');
                    });
                });
            });
            </script>
            <?php
        };
    }
    return $tabs;
}, 99);
