<?php
/*
Plugin Name: Woo & Post Word Count
Plugin URI:  https://sajibdigital.com/woo-post-wordcount/
Description: Adds word count columns for WooCommerce products (Long/Short Description) and blog posts (Content/Excerpt), supporting English and Bengali.
Version:     1.0
Author:      Sajib Hossain
Author URI:  https://sajibdigital.com/
License:     GPL2
Text Domain: woo-post-wordcount
*/

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) exit;

// ================================
// Helper function for UTF-8 word count
// ================================
function wpb_count_words_utf8( $text ) {
    $text = strip_tags($text); // Remove HTML tags
    $words = preg_split('/\s+/u', trim($text)); // Split words by space (UTF-8 safe)
    return count($words);
}

// ================================
// Add Columns for Products
// ================================
add_filter( 'manage_edit-product_columns', 'wpb_add_wordcount_columns_product', 15 );
function wpb_add_wordcount_columns_product( $columns ){
    $columns['long_description_wc'] = 'Long Desc Words';
    $columns['short_description_wc'] = 'Short Desc Words';
    return $columns;
}

// ================================
// Add Columns for Blog Posts
// ================================
add_filter( 'manage_posts_columns', 'wpb_add_wordcount_columns_post' );
function wpb_add_wordcount_columns_post( $columns ){
    $columns['long_description_wc'] = 'Content Words';
    $columns['short_description_wc'] = 'Excerpt Words';
    return $columns;
}

// ================================
// Show Word Count for Products
// ================================
add_action( 'manage_product_posts_custom_column', 'wpb_show_wordcount_columns_product', 10, 2 );
function wpb_show_wordcount_columns_product( $column, $post_id ){
    $post = get_post($post_id);

    if( $column == 'long_description_wc' ){
        echo wpb_count_words_utf8( $post->post_content );
    }

    if( $column == 'short_description_wc' ){
        echo wpb_count_words_utf8( $post->post_excerpt );
    }
}

// ================================
// Show Word Count for Blog Posts
// ================================
add_action( 'manage_posts_custom_column', 'wpb_show_wordcount_columns_post', 10, 2 );
function wpb_show_wordcount_columns_post( $column, $post_id ){
    $post = get_post($post_id);

    if( $post->post_type == 'post' ){ 
        if( $column == 'long_description_wc' ){
            echo wpb_count_words_utf8( $post->post_content );
        }

        if( $column == 'short_description_wc' ){
            $excerpt = $post->post_excerpt;
            if( empty($excerpt) ){
                // If excerpt is empty, take first 55 words from content
                $words = preg_split('/\s+/u', trim(strip_tags($post->post_content)));
                $excerpt = implode(' ', array_slice($words, 0, 55));
            }
            echo wpb_count_words_utf8( $excerpt );
        }
    }
}
